VERSION 5.00
Begin VB.Form DC_Transaction_list 
   Caption         =   "Form1"
   ClientHeight    =   7275
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   17145
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   7275
   ScaleWidth      =   17145
   StartUpPosition =   3  'Windows Default
   Begin Project1.ArmGrid grd_main 
      Height          =   4230
      Left            =   120
      TabIndex        =   0
      Tag             =   "grd_main"
      Top             =   810
      Width           =   6900
      _ExtentX        =   12171
      _ExtentY        =   7461
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   45
      TabIndex        =   1
      Top             =   0
      Width           =   6075
      _ExtentX        =   10716
      _ExtentY        =   1217
   End
   Begin Project1.ArmGrid grd_UOM 
      Height          =   1485
      Left            =   6810
      TabIndex        =   2
      Tag             =   "grd_UOM"
      Top             =   4725
      Width           =   5310
      _ExtentX        =   9366
      _ExtentY        =   2619
   End
End
Attribute VB_Name = "DC_Transaction_list"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'what is new
'3.0.1 : introduced
'3.0.2 : email for carriers

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Sub Sleep Lib "Kernel32" (ByVal dwMiliseconds As Long)

Private Const SCREEN_NAME As String = "DC_Transaction_list"
Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Private Const COLOR_PARENT As Long = ColorConstants.vbWhite
Private Const COLOR_CHILD As Long = ColorConstants.vbCyan

Private Const C_TOOLBAR_ID As Long = 2996

#If LIVE = 1 Then
    Dim mo_Db As Object
    Dim mo_FSO As Object
    'excel sheet object
    Private mo_Sheet As Object
    'excel application object
    Private mo_ExcelApp As Object
    Private Const xlDown = -4121 '(&HFFFFEFE7)
    Private Const xlFormatFromLeftOrAbove = 0
    Private Const xlEdgeBottom = 9
    Private Const xlContinuous = 1
    Private Const xlThick = 4
    
#Else
    Dim mo_Db As ARMSYSCOMLib.ArmDb
    Dim mo_FSO As Scripting.FileSystemObject
    'excel sheet object
    Private mo_Sheet As Excel.Worksheet
    'excel application object
    Private mo_ExcelApp As Excel.Application
#End If

Dim ms_MsgInfo As Variant
Dim ms_TempPrintFile As String
Dim msa_PDFDevice() As String                   ' list of supported PDF devices separated with SEP
Private mo_MailClient As MailClient ' Interface to send Email


Private ml_U_Code As Long
Private ms_LoginName As String
Private mb_Initialized As Boolean
Private ms_Language_Code As String

Private ms_reconnectServer As String
Private ms_reconnectDB As String
Private ms_reconnectUser As String
Private ms_reconnectPassword As String
Private ms_reconnectApp As String


Private ms_TableName As String
Private ms_DC_Code As String
Private ms_DC_Name As String
Private md_shippingDay As Date

Private ms_gridRequest As String
Private ms_detailRequest As String
Private ms_summaryRequest As String
Private ms_screenConstantsRequest As String
Private ms_securityRequest As String
Private mb_eventRunning As Boolean

Private mv_gridColumns As Variant

Private mb_needRefresh As Boolean

Private WithEvents mo_DC_Customer As DC_Customer
Attribute mo_DC_Customer.VB_VarHelpID = -1
Private WithEvents mo_DC_Interco As DC_Intercompany
Attribute mo_DC_Interco.VB_VarHelpID = -1
Private WithEvents mo_DC_Receipts As DC_Receipts
Attribute mo_DC_Receipts.VB_VarHelpID = -1

Dim mb_AllowAdd As Boolean ' flag if the user can add new information
Dim mb_AllowUpd As Boolean ' flag if the user can update new information
Dim mb_AllowDel As Boolean ' flag if the user can delete new information
Dim mb_AllowUpdI As Boolean ' flag if the user can update new information but only if the internet flag is not checked
Dim mb_AllowDelI As Boolean ' flag if the user can delete new information but only if the internet flag is not checked
Dim mb_AllowMemo As Boolean ' flag if the user can use the Memo
Dim ms_LanguagePermission As String

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
    InvalidValue = C_ERRORRAISE + 12          ' load function failed ... bad sql
    SQLTableReferenceConstraint = C_ERRORRAISE + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id

End Enum

Public Sub SetReconnectParams(ByVal as_Server As String, ByVal as_Db As String, ByVal as_User As String, ByVal as_Password As String, ByVal as_App As String)
On Error GoTo ErrHandler
    ms_reconnectServer = as_Server
    ms_reconnectDB = as_Db
    ms_reconnectUser = as_User
    ms_reconnectPassword = as_Password
    ms_reconnectApp = as_App
    Exit Sub
ErrHandler:
    Call ErrorMessage("SetReconnectParams")
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let Language_Code(AString As String)
On Error GoTo ErrHandler

  ms_Language_Code = AString
  Exit Property
ErrHandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler

  ml_U_Code = al_U_Code
  Exit Property
ErrHandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_loginName As String)
On Error GoTo ErrHandler
    
    ms_LoginName = as_loginName
    Exit Property
ErrHandler:
    Call ErrorMessage(Me.Name & ".LoginName(Let)")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = lo_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Let DC_Code(ByVal as_DC_Code As String)
    ms_DC_Code = as_DC_Code
End Property

Public Property Let DC_name(ByVal as_DC_Name As String)
    ms_DC_Name = as_DC_Name
End Property

Public Property Let ShippingDay(ByVal ad_shippingDay As Date)
    md_shippingDay = ad_shippingDay
End Property

Public Sub GridRequests(ByVal as_gridRequest As String, as_detailRequest As String, as_summaryRequest As String)
    ms_gridRequest = as_gridRequest
    ms_detailRequest = as_detailRequest
    ms_summaryRequest = as_summaryRequest
End Sub

Public Property Let ScreenConstantRequest(ByVal as_Request As String)
    ms_screenConstantsRequest = as_Request
End Property

Public Property Let SecurityRequest(ByVal as_Request As String)
    ms_securityRequest = as_Request
End Property

Public Property Let GridColumns(ByVal av_gridColumns As Variant)
    mv_gridColumns = av_gridColumns
End Property

Public Property Let TableName(ByVal as_tableName As String)
    ms_TableName = as_tableName
End Property


Public Sub Load_A_COM()
    
On Error GoTo ErrHandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    mb_eventRunning = True
    
    Dim lo_Control As Object
    Dim lo_ToolTip As Object
    
      For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
      Next
    
    ' init toolbar
    Dim ll_Cursor As Long
    
    ll_Cursor = OpenSQLSafe(mo_Db, "exec Toolbar_sel 'DC Load Plan'")
    
    If mo_Db.Find(ll_Cursor, "Id", C_TOOLBAR_ID) < 0 Then
        Err.Raise ArmErr.InvalidValue, tlb_Main.Name, "Toolbar not found in toolbars_definitions ID:" & C_TOOLBAR_ID
    End If

    Dim ls_ToolbarInfo  As String
    ls_ToolbarInfo = mo_Db.GetFields(ll_Cursor, "info")
    Call tlb_Main.SetToolbarInfoStringParameters(ls_ToolbarInfo, Left(ls_ToolbarInfo, 3))
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    ' init PDF printing files
    
    Set mo_FSO = CreateObject("Scripting.FileSystemObject")
    
    ms_TempPrintFile = Get_A_Config("DC_PDFPrintFilePath")
    msa_PDFDevice = Split(Get_A_Config("DC_PDFDevice"), SEP)
    
    Set mo_MailClient = New MailClient
    Set mo_MailClient.ArmDb = mo_Db
    mo_MailClient.U_Code = ml_U_Code
    mo_MailClient.Load_A_COM
    
    Call mo_MailClient.SetActiveMailBox(Trim(Get_A_Config("DC_MailBox")))
    
    grd_UOM.MultiSelect = False
    grd_UOM.AllowExcelExport = True
    grd_UOM.ExportTitles = True
    grd_UOM.FreeSelect = False
    grd_UOM.AllowSort = False
    grd_UOM.AllowPrint = True
    
    If Not grd_UOM.SetColumns(Array( _
                          Join(Array("uom_code", 1100, 1, "uom_code", "#uom_code", "String", "", "left"), SEP) _
                        , Join(Array("quantity", 1200, 0, "quantity", "#Quantity", "int", "", "right"), SEP) _
                        , Join(Array("maxqty", 1200, 0, "maxqty", "#Maximum Qty", "String", "", "right"), SEP) _
                        , Join(Array("remqty", 1200, 0, "remqty", "#Remining Qty", "String", "", "right"), SEP) _
                        )) Then
                        
                        
        MsgBox ("Grid not initialized!")
    End If
    
    ' init grig
    grd_main.ResetGrid
    grd_main.Title = "#Transactions rows"
    grd_main.MultiSelect = False
    grd_main.AllowSort = False
    grd_main.FreeSelect = True
    grd_main.AllowExcelExport = True
'    grd_main.AllowPrint = True
    grd_main.ExportOnlyVisibleColumns = False
    grd_main.ExportTitles = True
    grd_main.WordWrap = True
    
    Call ChangeCharset(Me.Controls, GetCodePageFromLanguage(mo_Db, ms_Language_Code))
    
    mb_eventRunning = False
    Exit Sub
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    mb_eventRunning = False
    Call ErrorHandler("Load_A_COM")
    
End Sub

Public Sub InitControl()
On Error GoTo ErrHandler
    
    Call grd_main.ClearGrid
    Call grd_main.ResetGrid
    
    If Not grd_main.SetColumns(mv_gridColumns) Then
        MsgBox ("Grid not initialized!")
    End If
    
    If ms_detailRequest <> "" Then
        grd_main.MasterDetailSetting = "IsMasterMasterDetailSubCount10" & COLOR_PARENT & SEP & COLOR_CHILD & "MINUSPLUS"
    
        grd_main.MasterDetailRequest = ms_detailRequest
        grd_main.RequestLoadDetails = True
    End If
    
    Call LoadLabels(Me.Controls, SCREEN_NAME, ms_Language_Code)
    
    If Not grd_main.Load(ms_gridRequest, False, , , False) Then
        MsgBox ("Grid not loaded!")
    End If
    
    ReDim ms_MsgInfo(1, 1)
    ms_MsgInfo(0, 0) = "$DC_NAME$"
    ms_MsgInfo(0, 1) = ms_DC_Name
    ms_MsgInfo(1, 0) = "$SHIPPING_DATE$"
    ms_MsgInfo(1, 1) = md_shippingDay
    
    If ms_TableName = "DC_Receipts" Or ms_TableName = "DC_Rec_End" Then
        grd_main.Title = MsgText(5292, ms_Language_Code, "#Receive to $DC_NAME$ - Receiving date : $SHIPPING_DATE$", ms_MsgInfo)
    Else
        grd_main.Title = MsgText(5291, ms_Language_Code, "#Ship from $DC_NAME$ - Shipping date : $SHIPPING_DATE$", ms_MsgInfo)
    End If
    
    If ms_summaryRequest <> "" Then
        If Not grd_UOM.Load(ms_summaryRequest, True) Then
            MsgBox ("Grid not loaded!")
        End If

        If ms_TableName <> "DC_Customer" And ms_TableName <> "DC_Cust_End" Then
            grd_UOM.Columns("remqty").Width = 0
            grd_UOM.Columns("maxqty").Width = 0
        Else
            grd_UOM.Columns("remqty").Width = 1200
            grd_UOM.Columns("maxqty").Width = 1200
        End If
        
        grd_UOM.Visible = True
    Else
        grd_UOM.Visible = False
    End If
    
    
    Call Permission
    
    Call tlb_Main.DisplayFace("0")
    
    ' add/help button are not visible when customer_end ....
    tlb_Main.ButtonVisible("A") = mb_AllowAdd
    tlb_Main.ButtonVisible("B") = mb_AllowUpd Or mb_AllowUpdI
    tlb_Main.ButtonVisible("C") = mb_AllowDel Or mb_AllowDelI
    tlb_Main.ButtonVisible("E") = mb_AllowMemo
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitControl")
End Sub

Public Sub Unload_A_COM()
    
On Error GoTo ErrHandler
    mb_Initialized = False
    
    Dim lo_Control As Object

    For Each lo_Control In Controls
      Select Case UCase(TypeName(lo_Control))
      Case "ARMCOMBOBOX"
        Call lo_Control.Unload_A_COM
      Case "ARMPICKER"
        Call lo_Control.Unload_A_COM
      Case "TOOLBARCONTROL"
        Call lo_Control.Unload_A_COM
      Case "ARMGRID"
        Call lo_Control.Unload_A_COM
      Case "ARMTREEVIEW"
        Call lo_Control.Unload_A_COM
      Case "ARMCHECKVIEW"
        Call lo_Control.Unload_A_COM
      Case "TOOLBR"
        Call lo_Control.Unload_A_COM
      End Select
    Next
    
    If Not mo_DC_Customer Is Nothing Then
        Call mo_DC_Customer.Unload_A_COM
        Unload mo_DC_Customer
        Set mo_DC_Customer = Nothing
    End If
    If Not mo_DC_Interco Is Nothing Then
        Call mo_DC_Interco.Unload_A_COM
        Unload mo_DC_Interco
        Set mo_DC_Interco = Nothing
    End If
    If Not mo_DC_Receipts Is Nothing Then
        Call mo_DC_Receipts.Unload_A_COM
        Unload mo_DC_Receipts
        Set mo_DC_Receipts = Nothing
    End If
    
    Set mo_FSO = Nothing
    Call mo_MailClient.Unload_A_COM
    Set mo_MailClient = Nothing

    
    Exit Sub
    
ErrHandler:
    
    Call ErrorHandler("UnLoad_A_Com")
    
End Sub

' Load the labels of a containers
Private Sub LoadLabels(ByRef aControls As Variant, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long, lLabels As Long
    Dim lControl As Control

    lLabels = OpenSQLSafe(mo_Db, ms_screenConstantsRequest)
    Debug.Assert (lLabels <> 0)
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON", "OPTIONBUTTON", "MENU", "CHECKBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                        ' once translation is done and control is not in array CLEAR tag
                        If Not TypeOf lControl Is Frame And Not TypeOf lControl Is Label Then
                            lControl.Tag = ""
                        End If
                    End If
                Case "ARMGRID"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                      Call lControl.LoadConstants(ptStatic, mo_Db.GetFields(lLabels, "LOCAL_TEXT"), ctColumns)
                        End If
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_Title", , 1) >= 0 Then
                      lControl.Title = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                    End If
                Case "TABSTRIP"
                    If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                        Dim lsa_TextArr() As String
                        Dim ll_Index As Long
                        
                        lsa_TextArr = Split(mo_Db.GetFields(lLabels, "LOCAL_TEXT"), SEP)
                        
                        For ll_Index = LBound(lsa_TextArr, 1) To UBound(lsa_TextArr, 1)
                            lControl.Tabs(ll_Index + 1).Caption = lsa_TextArr(ll_Index)
                        Next
                    End If
                    ' once translation is done and control is not in array CLEAR tag
                    lControl.Tag = ""
                Case "MSFLEXGRID", "TOOLBARCONTROL", "TEXTBOX", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TOOLBR", "SPINBUTTON"
                    ' Do nothing !
                Case Else
                    'debug.print "LoadLabels " & UCase(TypeName(lControl))
            End Select
        Set lControl = Nothing
    Next
    
    ' SPECIAL INITIALIZATION
    ' Title
    If mo_Db.Find(lLabels, "FIELD_NAME", "title", , 1) >= 0 Then
        Me.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
    End If

    Call mo_Db.Close(lLabels)
    lLabels = 0

    Exit Sub

ErrHandler:
    If lLabels > 0 Then
        Call mo_Db.Close(lLabels)
    End If
    Call ErrorHandler(Me.Name & ".LoadLabels")
End Sub


Private Sub ChangeCharset(ByRef ao_Container As Object, Optional ByVal aCodePage As Long)
On Error GoTo ErrHandler
   
    Dim lc_Control As Control
    Dim ll_Charset As Long
    
    On Error Resume Next
    ll_Charset = GetCharSetFromCodePage(aCodePage)
    
    For Each lc_Control In ao_Container
        Select Case UCase(TypeName(lc_Control))
        Case "TABSTRIP", "TEXTBOX", "LABEL", "FRAME", "COMMANDBUTTON", _
              "LISTVIEW", "CHECKBOX", "OPTIONBUTTON", _
              "ARMCHECKVIEW", "ARMTREEVIEW", "ARMGRID", "ARMCOMBOBOX", "ARMCHECKVIEW0"
            lc_Control.Font.Name = "Arial"
            lc_Control.Font.Charset = ll_Charset
        Case "A_SEEK", "A_SRCHTXT"
            lc_Control.Charset = ll_Charset
        End Select
    Next
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Me.Name & ".ChangeCharset")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
'    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
'    End
End Sub


' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, Me.Name & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data)
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler("OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise ArmErr.SQLTableReferenceConstraint, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function
Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

Private Sub Form_Resize()
On Error GoTo ErrHandler
    If Me.Width < 11910 Then
        Exit Sub
    End If
    
    If Me.Height < 5500 Then
        Exit Sub
    End If
    
    Const SPACE As Long = 60
    
    Call tlb_Main.Move(Me.ScaleLeft, Me.ScaleTop, Me.ScaleWidth)
    
    If ms_summaryRequest = "" Then
        Call grd_main.Move(tlb_Main.Left, tlb_Main.Top + tlb_Main.Height, tlb_Main.Width, Me.ScaleHeight - tlb_Main.Top - tlb_Main.Height)
    Else
        Call grd_main.Move(tlb_Main.Left, tlb_Main.Top + tlb_Main.Height, tlb_Main.Width, Me.ScaleHeight - tlb_Main.Top - tlb_Main.Height - grd_UOM.Height)
        Call grd_UOM.Move(grd_main.Left + grd_main.Width - grd_UOM.Width, grd_main.Top + grd_main.Height)
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage("Form_Resize")
End Sub

Private Sub Permission()
On Error GoTo ErrHandler

    Dim ls_Perm As String
    Dim ll_Cursor As Long
    
    mb_AllowAdd = KO
    mb_AllowDel = KO
    mb_AllowUpd = KO
    mb_AllowDelI = KO
    mb_AllowUpdI = KO
    mb_AllowMemo = KO
    ms_LanguagePermission = ""
    
    ll_Cursor = OpenSQLSafe(mo_Db, ms_securityRequest)
    
    Do While Not mo_Db.EOF(ll_Cursor)
        ls_Perm = mo_Db.GetFields(ll_Cursor, "Action")
        If ls_Perm = "Insert" Then
            If right(ms_TableName, 4) <> "_End" Then mb_AllowAdd = OK
        End If
        If ls_Perm = "Delete" Then
            If right(ms_TableName, 4) <> "_End" Then mb_AllowDel = OK
        End If
        If ls_Perm = "Update" Then
            mb_AllowUpd = OK
        End If

        If ls_Perm = "UpdateI" Then
            mb_AllowUpdI = OK
        End If
        If ls_Perm = "DeleteI" Then
            mb_AllowDelI = OK
        End If
        If ls_Perm = "Memo" Then
            If right(ms_TableName, 4) <> "_End" Then mb_AllowMemo = OK
        End If
        If Left(ls_Perm, 3) = "99_" Then
            ms_LanguagePermission = ms_LanguagePermission & right(ls_Perm, Len(ls_Perm) - 3)
        End If
        Call mo_Db.Next(ll_Cursor)
    Loop
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("Permission()")
End Sub

Private Sub grd_main_AfterExcelExport(ByVal ao_ExcelApp As Object, ByVal ao_ExcelWorkbook As Object, ByVal ao_ExcelSheet As Object)

On Error GoTo ErrorHandler
    If Not (ao_ExcelSheet Is Nothing) Then
    Select Case ms_TableName
    Case "DC_Customer", "DC_Cust_End"
        ' remove hidden fields
        If grd_main.ExportOnlyVisibleColumns = False Then
            Call GridRemoveHiddenFields(ao_ExcelSheet, Array("TRANS_Code", "MasterDetail", "IsMaster", "SubCount", "iConcurrency"))
        End If
        Call ExcelAddFormating(ao_ExcelSheet, ms_DC_Name & " - Shipping date : " & md_shippingDay, Array("M:M", "J:J"))
    End Select
    End If
    Exit Sub
ErrorHandler:
    Call ErrorMessage("grd_main_AfterExcelExport")
End Sub

Private Sub GridRemoveHiddenFields(ByVal ao_ExcelSheet As Object, ByVal asa_colsToDelete As Variant)
On Error GoTo ErrHandler

    Dim ll_i As Long
    
    For ll_i = UBound(asa_colsToDelete) To LBound(asa_colsToDelete) Step -1
        ' remove from excell colums
        ao_ExcelSheet.Columns(grd_main.Columns(asa_colsToDelete(ll_i)).ColumnIndex + 1).EntireColumn.Delete
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("GridRemoveHiddenFields")
End Sub


Private Sub grd_main_DblClick()
On Error GoTo ErrHandler
    If grd_main.Col = 2 Then Exit Sub
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True
    
    LockScreen (True)

    If grd_main.SelectedCount > 0 Then
        Call Item_ViewInit(grd_main.SelectedKey(0))
    End If

    LockScreen (False)
    
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    LockScreen (False)
    mb_eventRunning = False
    Call ErrorMessage("grd_main_DblClick")
End Sub

Private Sub grd_Main_RowLoaded(ByVal al_Row As Long)
On Error GoTo ErrHandler

    Static ll_MasterRow As Long
    
    If al_Row = 0 Then
        ll_MasterRow = 0
    End If
    
    If grd_main.Data(al_Row, "IsMaster") = 1 Then
        ll_MasterRow = ll_MasterRow + 1
        If ll_MasterRow Mod 2 = 1 Then
            grd_main.LineColor(al_Row) = RGB(220, 220, 220)
        Else
            grd_main.LineColor(al_Row) = vbWhite
        End If
    Else
        If al_Row > 0 Then
            grd_main.LineColor(al_Row) = grd_main.LineColor(al_Row - 1)
        End If
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("grd_main_RowLoaded")
End Sub

Private Sub grd_UOM_RowLoaded(ByVal al_Row As Long)
    If grd_UOM.Data(al_Row, "remqty") <> "" Then
        If grd_UOM.Data(al_Row, "remqty") < 0 Then
            grd_UOM.CellColor(al_Row, "remqty") = RGB(255, 0, 0)
        End If
    End If
End Sub

Private Sub mo_DC_Customer_RowAdded(ByVal av_Data As Variant)
On Error GoTo ErrHandler
    
    Call grd_main.AddLine(av_Data)
    
    If ms_summaryRequest <> "" Then
        ' refresh summary
        Call grd_UOM.Refresh
    End If
    
    mb_needRefresh = True
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("mo_DC_Customer_RowAdded")
End Sub

Private Sub mo_DC_Customer_RowDeleted(ByVal av_Key As Variant)
On Error GoTo ErrHandler
    
    If grd_main.SelectedCount = 0 Then
        Call grd_main.SearchKey(True, av_Key)
    Else
        If grd_main.SelectedKey(0)(0) <> av_Key(0) Then
            Call grd_main.SearchKey(True, av_Key)
        End If
    End If
    
    Call grd_main.DeleteSelectedLines
    
    If ms_summaryRequest <> "" Then
        ' refresh summary
        Call grd_UOM.Refresh
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage("mo_DC_Customer_RowDeleted")
End Sub

Private Sub mo_DC_Customer_RowUpdated(ByVal av_Data As Variant)
On Error GoTo ErrHandler
    
    Dim ll_i As Long
    For ll_i = LBound(av_Data) To UBound(av_Data)
        grd_main.Data(grd_main.Row, ll_i) = av_Data(ll_i)
    Next
    
    If ms_summaryRequest <> "" Then
        ' refresh summary
        Call grd_UOM.Refresh
    End If
    
    mb_needRefresh = True

    Exit Sub
ErrHandler:
    Call ErrorMessage("mo_DC_Customer_RowUpdated")
End Sub

Private Sub mo_DC_Interco_RowAdded(ByVal av_Data As Variant)
    Call mo_DC_Customer_RowAdded(av_Data)
End Sub

Private Sub mo_DC_Interco_RowDeleted(ByVal av_Key As Variant)
    Call mo_DC_Customer_RowDeleted(av_Key)
End Sub

Private Sub mo_DC_Interco_RowUpdated(ByVal av_Data As Variant)
    Call mo_DC_Customer_RowUpdated(av_Data)
End Sub

Private Sub mo_DC_Receipts_RowAdded(ByVal av_Data As Variant)
    Call mo_DC_Customer_RowAdded(av_Data)
End Sub

Private Sub mo_DC_Receipts_RowDeleted(ByVal av_Key As Variant)
    Call mo_DC_Customer_RowDeleted(av_Key)
End Sub

Private Sub mo_DC_Receipts_RowUpdated(ByVal av_Data As Variant)
    Call mo_DC_Customer_RowUpdated(av_Data)
End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True
    
    Dim lo_result As VbMsgBoxResult

    LockScreen (True)
    
    Select Case as_Role
    Case "A"
        Call Item_AddInit
    Case "B"    ' Update, refresh detail
        If grd_main.SelectedCount > 0 Then
            Call Item_UpdateInit(grd_main.SelectedKey(0))
        Else
            Call SendMessage(2404, "#Please select a row.", ms_Language_Code, vbOKOnly)
        End If
    
    Case "C"
        If grd_main.SelectedCount > 0 Then
            Call Item_DeleteInit(grd_main.SelectedKey(0))
        Else
            Call SendMessage(2404, "#Please select a row.", ms_Language_Code, vbOKOnly)
        End If
    Case "D"        ' print
        
        If grd_main.SelectedCount > 0 And ms_TableName <> "DC_Cust_End" And ms_TableName <> "DC_Int_End" Then
            ReDim ms_MsgInfo(0, 1)
            ms_MsgInfo(0, 0) = "$CARRIER$"
            ms_MsgInfo(0, 1) = grd_main.SelectedLine(0, "CARRIER_Name")
            lo_result = MsgBox(MsgText(5290, ms_Language_Code, "#Press NO to print Complete list" & vbCrLf & "Press YES to print Selected Carrier ($CARRIER$) only.", ms_MsgInfo), vbQuestion Or vbYesNoCancel)
            If lo_result = vbNo Then
                Call DCLoadPrint("")
            ElseIf lo_result = vbYes Then
                ' partial
                Call DCLoadPrint(grd_main.SelectedLine(0, "CARRIER_Code"))
            End If
        Else
            Call DCLoadPrint("")
        End If
        
    Case "F"        ' refresh grid
        Call grd_main.Refresh
        mb_needRefresh = False
    Case "M"        ' search
    
        gi_SearchGrid = 4
        Set C_search.mo_grid4 = grd_main
        C_search.show 1
        Set C_search.mo_grid4 = Nothing
        
    Case "G"        ' excell export
        If grd_main.SelectedCount > 0 Then
            ReDim ms_MsgInfo(0, 1)
            ms_MsgInfo(0, 0) = "$CARRIER$"
            ms_MsgInfo(0, 1) = grd_main.SelectedLine(0, "CARRIER_Name")
            lo_result = MsgBox(MsgText(5300, ms_Language_Code, "#Press NO to export Complete list" & vbCrLf & "Press YES to export Selected Carrier ($CARRIER$) only.", ms_MsgInfo), vbQuestion Or vbYesNoCancel)
            If lo_result = vbNo Then
                Call grd_main.ExportToExcel(True)
            ElseIf lo_result = vbYes Then
                ' partial
                Call ExportToExcel(grd_main, grd_main.ExportTitles, "CARRIER_Code", grd_main.SelectedLine(0, "CARRIER_Code"))
            End If
            
        Else
            Call grd_main.ExportToExcel(True)
        End If
        
    Case "u"                ' send email
        If HaveRight("DC_PRINT_EML_USER") Then
            If grd_main.SelectedCount > 0 And ms_TableName <> "DC_Cust_End" And ms_TableName <> "DC_Int_End" Then
                Call EmailDCPrint(grd_main.SelectedLine(0, "CARRIER_Code"), grd_main.SelectedLine(0, "CARRIER_Name"), GetEmailForCarrier(grd_main.SelectedLine(0, "CARRIER_Code")), grd_main.SelectedLine(0, "PrefLanguage"))
            Else
                Call SendMessage(2404, "#Please select a row.", ms_Language_Code, vbOKOnly)
            End If
        Else
            Call SendMessage(5390, "#You are not authorized to send emails." & vbCrLf & " If it is necessary contact administrator.", ms_Language_Code, vbOKOnly Or vbInformation)
        End If
    
    Case "S"
        frm_help.show 1
    Case "T"
        Me.Hide
    End Select

'    Call FlushMouseMessages
    LockScreen (False)
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    LockScreen (False)
    mb_eventRunning = False
    Call ErrorMessage("tlb_main_action")
End Sub

Private Function GetEmailForCarrier(ByVal as_CARRIER_Code As String) As String
On Error GoTo ErrHandler
Const C_REQ As String = "SELECT CARRIER_Email FROM DC_Carrier WHERE CARRIER_Code=$CARRIER_Code$"

    GetEmailForCarrier = ""
    
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(C_REQ, "$CARRIER_Code$", SqlStr(as_CARRIER_Code, 10), , , vbTextCompare)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    If Not mo_Db.EOF(ll_Cursor) Then
        GetEmailForCarrier = mo_Db.GetFields(ll_Cursor, "CARRIER_Email")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("GetEmailForCarrier")
End Function

Private Sub Item_AddInit()
On Error GoTo ErrHandler
    gs_Action = "Add"
    
    Select Case ms_TableName
    Case "DC_Customer"
        Call Launch_DC_Customer(0)
    Case "DC_Interco"
        Call Launch_DC_Interco(0)
    Case "DC_Receipts"
        Call Launch_DC_Receipts(0)
    Case Else
        Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_AddInit")
End Sub

Private Sub Item_UpdateInit(ByVal av_Key As Variant)
On Error GoTo ErrHandler
    
    gs_Action = "Update"

    Select Case ms_TableName
    Case "DC_Customer", "DC_Cust_End"
        Call Launch_DC_Customer(av_Key(0))
    Case "DC_Interco", "DC_Int_End"
        Call Launch_DC_Interco(av_Key(0))
    Case "DC_Receipts", "DC_Rec_End"
        Call Launch_DC_Receipts(av_Key(0))
    Case Else
        Debug.Assert (False)
    End Select
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateInit")
End Sub

Private Sub Item_DeleteInit(ByVal av_Key As Variant)
On Error GoTo ErrHandler
    gs_Action = "Delete"
    
    Select Case ms_TableName
    Case "DC_Customer"
        Call Launch_DC_Customer(av_Key(0))
    Case "DC_Interco"
        Call Launch_DC_Interco(av_Key(0))
    Case "DC_Receipts"
        Call Launch_DC_Receipts(av_Key(0))
    Case Else
        Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_DeleteInit")
End Sub

Private Sub Item_ViewInit(ByVal av_Key As Variant)
On Error GoTo ErrHandler
    gs_Action = "MoreInfo"
    
    Select Case ms_TableName
    Case "DC_Customer", "DC_Cust_End"
        Call Launch_DC_Customer(av_Key(0))
    Case "DC_Interco", "DC_Int_End"
        Call Launch_DC_Interco(av_Key(0))
    Case "DC_Receipts", "DC_Rec_End"
        Call Launch_DC_Receipts(av_Key(0))
    Case Default
        Debug.Assert (False)
    End Select

    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_ViewInit")
End Sub



Private Function Launch_DC_Customer(ByVal al_TRANS_Code As Long) As Boolean
    On Error GoTo onError
    
    Launch_DC_Customer = False
    
    DoEvents
    
    If mo_DC_Customer Is Nothing Then
    
        Set mo_DC_Customer = New DC_Customer
        
        Set mo_DC_Customer.ArmDb = mo_Db
        mo_DC_Customer.Language_Code = gut_LangLogin.Code
        mo_DC_Customer.U_Code = prg.U_Code
        mo_DC_Customer.LoginName = prg.LoginName
        
        Call mo_DC_Customer.SetReconnectParams(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, prg.ApplicationName & prg.ApplicationVersion)
        
        Call mo_DC_Customer.Load_A_COM
        If Not mo_DC_Customer.Initialized Then
            Call ASC_SendMessage(mo_Db, prg.Session_language_Code, 8729, "You do not have rights to access this application. Please contact your IT support.")
            Call mo_DC_Customer.Unload_A_COM
            Set mo_DC_Customer = Nothing
            Exit Function
        End If
    End If
    
    mo_DC_Customer.DC_Code = DC_Choice.cbo_ShipDC_code.List(DC_Choice.cbo_ShipDC.ListIndex)
    mo_DC_Customer.DC_name = DC_Choice.cbo_ShipDC.Text
    mo_DC_Customer.ShippingDay = StringToDate(DC_Choice.txt_ShipDate)
    mo_DC_Customer.TRANS_Code = al_TRANS_Code
    mo_DC_Customer.TableName = ms_TableName
    
    Call mo_DC_Customer.InitControl
    
    Call LockScreen(False)
    
    Call mo_DC_Customer.show(1)
    
    Call LockScreen(True)
    
    ' keep selection of possible
    Dim lv_Key As Variant
    Dim ll_Col As Long
    
    If grd_main.SelectedCount > 0 Then
        lv_Key = grd_main.SelectedKey(0)
        ll_Col = grd_main.Col
    End If
    
    If mb_needRefresh Then
        Call grd_main.Refresh
        mb_needRefresh = False
        
        If Not IsEmpty(lv_Key) Then
            If grd_main.SearchKey(True, lv_Key) Then
                grd_main.Col = ll_Col
            End If
        End If
    End If
    
    
    Launch_DC_Customer = True
    Exit Function
onError:
    Launch_DC_Customer = False
    Set mo_DC_Customer = Nothing
    Call ErrorMessage("Launch_DC_Customer")
End Function


Private Function Launch_DC_Interco(ByVal al_TRANS_Code As Long) As Boolean
    On Error GoTo onError
    
    Launch_DC_Interco = False
    
    If mo_DC_Interco Is Nothing Then
    
        Set mo_DC_Interco = New DC_Intercompany
        
        Set mo_DC_Interco.ArmDb = mo_Db
        mo_DC_Interco.Language_Code = gut_LangLogin.Code
        mo_DC_Interco.U_Code = prg.U_Code
        mo_DC_Interco.LoginName = prg.LoginName
        
        Call mo_DC_Interco.SetReconnectParams(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, prg.ApplicationName & prg.ApplicationVersion)
        
        Call mo_DC_Interco.Load_A_COM
        If Not mo_DC_Interco.Initialized Then
            Call ASC_SendMessage(mo_Db, prg.Session_language_Code, 8729, "You do not have rights to access this application. Please contact your IT support.")
            Call mo_DC_Interco.Unload_A_COM
            Set mo_DC_Interco = Nothing
            Exit Function
        End If
    End If
    mo_DC_Interco.DC_Code = DC_Choice.cbo_ShipDC_code.List(DC_Choice.cbo_ShipDC.ListIndex)
    mo_DC_Interco.DC_name = DC_Choice.cbo_ShipDC.Text
    mo_DC_Interco.ShippingDay = StringToDate(DC_Choice.txt_ShipDate)
    mo_DC_Interco.TRANS_Code = al_TRANS_Code
    mo_DC_Interco.TableName = ms_TableName
    Call mo_DC_Interco.InitControl
    
    Call LockScreen(False)
    
    Call mo_DC_Interco.show(1)
    
    LockScreen (True)
    
    ' keep selection of possible
    Dim lv_Key As Variant
    Dim ll_Col As Long
    
    If grd_main.SelectedCount > 0 Then
        lv_Key = grd_main.SelectedKey(0)
        ll_Col = grd_main.Col
    End If
    
    If mb_needRefresh Then
        Call grd_main.Refresh
        mb_needRefresh = False
        
        If Not IsEmpty(lv_Key) Then
            If grd_main.SearchKey(True, lv_Key) Then
                grd_main.Col = ll_Col
            End If
        End If
    End If
    
    
    Launch_DC_Interco = True
    Exit Function
onError:
    Launch_DC_Interco = False
    MsgBox "Unable to launch DC_Interco application: " & Err.Description
    Set mo_DC_Interco = Nothing
End Function

Private Function Launch_DC_Receipts(ByVal al_TRANS_Code As Long) As Boolean
    On Error GoTo onError
    
    Launch_DC_Receipts = False
    
    If mo_DC_Receipts Is Nothing Then
    
        Set mo_DC_Receipts = New DC_Receipts
        
        Set mo_DC_Receipts.ArmDb = mo_Db
        mo_DC_Receipts.Language_Code = gut_LangLogin.Code
        mo_DC_Receipts.U_Code = prg.U_Code
        mo_DC_Receipts.LoginName = prg.LoginName
        
        Call mo_DC_Receipts.SetReconnectParams(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, prg.ApplicationName & prg.ApplicationVersion)
        
        Call mo_DC_Receipts.Load_A_COM
        If Not mo_DC_Receipts.Initialized Then
            Call ASC_SendMessage(mo_Db, prg.Session_language_Code, 8729, "You do not have rights to access this application. Please contact your IT support.")
            Call mo_DC_Receipts.Unload_A_COM
            Set mo_DC_Receipts = Nothing
            Exit Function
        End If
    End If
    mo_DC_Receipts.DC_Code = DC_Choice.cbo_ShipDC_code.List(DC_Choice.cbo_ShipDC.ListIndex)
    mo_DC_Receipts.DC_name = DC_Choice.cbo_ShipDC.Text
    mo_DC_Receipts.ReceivingDay = StringToDate(DC_Choice.txt_ShipDate)
    mo_DC_Receipts.TRANS_Code = al_TRANS_Code
    mo_DC_Receipts.TableName = ms_TableName
    Call mo_DC_Receipts.InitControl
    
    Call LockScreen(False)
    
    Call mo_DC_Receipts.show(1)
    
    LockScreen (True)
    
    ' keep selection of possible
    Dim lv_Key As Variant
    Dim ll_Col As Long
    
    If grd_main.SelectedCount > 0 Then
        lv_Key = grd_main.SelectedKey(0)
        ll_Col = grd_main.Col
    End If
    
    If mb_needRefresh Then
        Call grd_main.Refresh
        mb_needRefresh = False
        
        If Not IsEmpty(lv_Key) Then
            If grd_main.SearchKey(True, lv_Key) Then
                grd_main.Col = ll_Col
            End If
        End If
    End If
    
    
    Launch_DC_Receipts = True
    Exit Function
onError:
    Launch_DC_Receipts = False
    MsgBox "Unable to launch DC_Interco application: " & Err.Description
    Set mo_DC_Receipts = Nothing
End Function

Private Sub DCLoadPrint(ByVal as_CARRIER_Code As String)

On Error GoTo ErrHandler

    Dim ls_req As String
    Dim llp_pos() As TCell
    
    Select Case ms_TableName
    Case "DC_Customer"
        
        Call InitPrinter2(PrinterObjectConstants.vbPRORLandscape)
        Printer.ScaleMode = ScaleModeConstants.vbCharacters
        Call RecalcMargins(vbCharacters)
        
        ls_req = "EXEC DC_ShipPrint4 " & SqlStr(ms_DC_Code, 4) & ", " & SqlDate(md_shippingDay) & ", " & SqlStr(as_CARRIER_Code, 10, True)
        
        Call DCCustomerLayout(llp_pos)
    
    Case "DC_Interco"
        
        ls_req = "EXEC DC_ShipPrint5 " & SqlStr(ms_DC_Code, 4) & ", " & SqlDate(md_shippingDay) & ", " & SqlStr(as_CARRIER_Code, 10, True)
        Call InitPrinter2(PrinterObjectConstants.vbPRORLandscape)
        Printer.ScaleMode = ScaleModeConstants.vbCharacters
        
        Call RecalcMargins(vbCharacters)
    
        Call DCIntercompanyLayout(llp_pos)
    
    Case "DC_Receipts"
        ' old print style
        
        ReDim ms_Print(13, 1) As String
        ms_Print(0, 0) = "Supplier"
        ms_Print(1, 0) = "Order n"
        ms_Print(2, 0) = "Shipment n"
        ms_Print(3, 0) = "Carrier Name"
        ms_Print(4, 0) = "Quantity"
        ms_Print(5, 0) = "Container n"
        ms_Print(6, 0) = "Remarks"
        ms_Print(7, 0) = "Unload by"
        ms_Print(8, 0) = "Start"
        ms_Print(9, 0) = ""
        ms_Print(10, 0) = ""
        ms_Print(11, 0) = ""
        ms_Print(12, 0) = ""
        ls_req = "EXEC DC_ShipPrint2 " & SqlStr(ms_DC_Code, 4) & ", " & SqlDate(md_shippingDay) & ", " & SqlStr(as_CARRIER_Code, 10, True)

        Dim ll_Cursor As Long
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
        
        Do While Not mo_Db.EOF(ll_Cursor)
            ReDim Preserve ms_Print(13, UBound(ms_Print, 2) + 1)
            Dim i As Long
            For i = 0 To 13
                ms_Print(i, UBound(ms_Print, 2) - 1) = mo_Db.GetFields(ll_Cursor, i)
            Next i
            
            
            Call mo_Db.Next(ll_Cursor)
        Loop
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        
        DCShipPrint ms_Print, KO
        Exit Sub
        
    Case "DC_Cust_End"
        Call PrintArmGrid(Array(grd_main.Columns("CUSTN1"), _
                            grd_main.Columns("Quantity"), _
                            grd_main.Columns("Shipment_Number")), _
                      Array(60, 20, 20), "Customer shipment", "", 1, 10)
    
    Case "DC_Int_End"
        
        Call PrintArmGrid(Array(grd_main.Columns("DC_desc"), _
                            grd_main.Columns("Order_Number"), _
                            grd_main.Columns("CARRIER_Name")), _
                      Array(60, 20, 20), "Intercompany shipment", "", 1, 10)
    
    Case "DC_Rec_End"
        
        Call PrintArmGrid(Array(grd_main.Columns("DC_desc"), _
                            grd_main.Columns("Order_Number"), _
                            grd_main.Columns("CARRIER_Name")), _
                      Array(60, 20, 20), "Receipts", "", 1, 10)
    Case Else
        MsgBox ("Print not supported")
        Exit Sub
    End Select
    
    If ls_req <> "" Then
    
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req)

        Call DCShipPrint2(mo_Db, ll_Cursor, llp_pos, "SHIPMENT LIST OF " & UCase(ms_DC_Name) & " PLANT", "Shipping date : " & md_shippingDay)
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    
    End If

    Exit Sub

ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("DCLoadPrint")
End Sub

Function RTrimInvisibleChars(ByVal as_str As String) As String
    Dim ll_char As Integer
    
    RTrimInvisibleChars = ""
    
    as_str = RTrim(as_str)
    
    If Len(as_str) = 0 Then
        Exit Function
    End If
    
    ll_char = Asc(Mid(as_str, Len(as_str), 1))
    
    While Len(as_str) > 0 And (ll_char = 10 Or ll_char = 13)
        as_str = Left(as_str, Len(as_str) - 1)
        If Len(as_str) > 0 Then
            ll_char = Asc(Mid(as_str, Len(as_str), 1))
        End If
    Wend
    
    RTrimInvisibleChars = as_str

End Function

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Refresh
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID, , , vbTextCompare)
    lRequest = Replace(lRequest, "$lang$", aLang, , , vbTextCompare)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_idx As Integer
    If Not IsMissing(aInfo) Then
        For li_idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_idx, 0), aInfo(li_idx, 1), , , vbTextCompare)
        Next li_idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

' *********************************** copy of grid export functionality *******************************************
'export grid content into MS Excel application
Private Function ExportToExcel(ByRef ao_grid As ArmGrid, ab_ExportTitles As Boolean, ByVal as_filterField As String, ByVal as_filterValue As String)
Dim lv_Columns As Variant
Dim ll_RowIndex As Long
Dim lb_Result As Boolean

On Error GoTo ErrorHandler
  
    lb_Result = False
    If ao_grid.Cols > 0 Then
      
        lv_Columns = GetColumnIndexes(ao_grid, ao_grid.ExportOnlyVisibleColumns)
            
        Dim ll_exportRow As Long
        If ExportOpen(ao_grid, lv_Columns, ab_ExportTitles, ll_exportRow) Then
         
          lb_Result = True
          For ll_RowIndex = 0 To ao_grid.Rows - 1
            If ao_grid.Data(ll_RowIndex, as_filterField) = as_filterValue Then
                If Not ExportRow(ao_grid, lv_Columns, ll_RowIndex, ll_exportRow) Then
                  lb_Result = False
                  Exit For
                End If
            End If
          Next
        Else
          lb_Result = False
        End If
        
        Call grd_main_AfterExcelExport(mo_ExcelApp, Nothing, mo_Sheet)
        
'        Call ExcelAddFormating(mo_Sheet, ms_DC_Name & " - Shipping date : " & md_shippingDay)
        
        Call ExportClose
    End If
    
    ExportToExcel = lb_Result

    Exit Function
ErrorHandler:
    Call ExportClose
    ExportToExcel = False
    Call ErrorHandler("ExportToExcel")
End Function

Private Function ExportRow(ByRef ao_grid As ArmGrid, ByVal av_columns As Variant, ByVal al_RowIndex As Long, ByRef al_exportRow As Long) As Boolean
Dim ll_Col As Long, ll_ColCount As Long
Dim lv_Data As Variant, lv_Value As Variant
Dim lo_Column As ArmColumn

On Error GoTo ErrorHandler
  If Not IsArray(av_columns) Then Exit Function
  
  If UBound(av_columns) > 0 Then
    ll_ColCount = UBound(av_columns) + 1
    
    ReDim lv_Data(ll_ColCount - 1)
    
    For ll_Col = 0 To ll_ColCount - 1
      Set lo_Column = ao_grid.Columns(av_columns(ll_Col))
      
      lv_Value = lo_Column.GetData(al_RowIndex)
      Select Case lo_Column.FieldType
      Case DBTYPE_STR, DBTYPE_BSTR
            lv_Data(ll_Col) = "'" & Left(lv_Value, 910)
      Case DBTYPE_DATE
          If lv_Value = 0 Then lv_Value = Empty
          lv_Data(ll_Col) = lv_Value
      Case Else
          lv_Data(ll_Col) = lv_Value
      End Select
    Next
    ExportRow = ExportArray(al_exportRow, lv_Data)
  End If
  Exit Function
ErrorHandler:
    ExportRow = False
    Call ErrorHandler("ExportRow")
End Function

Private Function ExportArray(ByRef al_currentRow As Long, av_Data As Variant) As Boolean
Dim ll_Col As Long


On Error GoTo ErrorHandler
  mo_Sheet.Range(mo_Sheet.cells(al_currentRow + 1, 1), _
                 mo_Sheet.cells(al_currentRow + 1, UBound(av_Data) + 1)) = av_Data
  
  al_currentRow = al_currentRow + 1
  ExportArray = True
  Exit Function
ErrorHandler:
    ExportArray = False
    Call ErrorHandler("ExportArray")
End Function

Private Function ExportOpen(ByRef ao_grid As ArmGrid, av_columns As Variant, ByVal ab_ExportTitles As Boolean, ByRef al_currentRow As Long) As Boolean
Dim lb_Result As Boolean
Dim ll_Idx As Long

On Error GoTo ErrorHandler
  
  lb_Result = False
  
  If NewExcelDocument Then
    mo_ExcelApp.ScreenUpdating = False
    mo_ExcelApp.Cursor = 2
    Set mo_Sheet = mo_ExcelApp.ActiveSheet
    If Not (mo_Sheet Is Nothing) Then
      If ab_ExportTitles Then
        If IsArray(av_columns) Then
            For ll_Idx = 0 To UBound(av_columns)
              mo_Sheet.cells(1, ll_Idx + 1) = "'" & ao_grid.Columns(av_columns(ll_Idx)).Title
            Next
          al_currentRow = 1
          lb_Result = True
        End If
      Else
        al_currentRow = 0
        lb_Result = True
      End If
    End If
  End If
  
  ExportOpen = lb_Result

  Exit Function
ErrorHandler:
    ExportOpen = False
    Call ErrorHandler("ExportOpen")
End Function

Private Function ExportClose() As Boolean

On Error GoTo ErrorHandler
#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(True, "ArmGrid:ExportClose")
#End If
  
  ExportClose = False
  If Not (mo_ExcelApp Is Nothing) Then
    mo_ExcelApp.ScreenUpdating = True
    mo_ExcelApp.Cursor = -4143
    Set mo_Sheet = Nothing
    Set mo_ExcelApp = Nothing
    ExportClose = True
  End If

#If CompDebugGR Then
  Call mo_Trace.WriteTraceProc(False, "ArmGrid:ExportClose")
#End If
  Exit Function
ErrorHandler:
    ExportClose = False
    Call ErrorHandler("ExportClose")
End Function

Private Function NewExcelDocument() As Boolean
Dim lo_WorkBook As Object
Dim lo_WorkSheet As Object

    NewExcelDocument = False
    
    On Error GoTo Err_NotLoaded
    
    Set mo_ExcelApp = GetObject(, "Excel.Application")
    
    If mo_ExcelApp Is Nothing Then
        Set mo_ExcelApp = CreateObject("Excel.Application")
    End If
    
    If mo_ExcelApp Is Nothing Then GoTo ErrorHandler
    
    On Error GoTo ErrorHandler
    
    Set lo_WorkBook = mo_ExcelApp.Workbooks.Add
    Set lo_WorkSheet = lo_WorkBook.Worksheets(1)
    mo_ExcelApp.Application.Visible = True
    lo_WorkSheet.Application.Visible = True

    NewExcelDocument = True

    Exit Function
    
Err_NotLoaded:
    If Err.Number = 429 Then
        Resume Next
    End If
    
ErrorHandler:
    Set mo_ExcelApp = Nothing
    Call ErrorHandler("NewExcelDocument")
End Function

Private Sub ExcelAddFormating(ByVal ao_ExcelSheet As Object, ByVal as_title As String, ByVal asa_invisibleCols As Variant)
Dim lv_Criteria As Variant
Dim ll_Index As Long

On Error GoTo ErrorHandler
 If Not (ao_ExcelSheet Is Nothing) Then
 
    ' insert one line at the top
    Call ao_ExcelSheet.Range("1:1").Insert(xlDown, xlFormatFromLeftOrAbove)
    
    ' columns to be autofit
    ao_ExcelSheet.UsedRange.Columns.EntireColumn.AutoFit

    Dim ll_visible_col As Long
    
    ll_visible_col = 1
    
    Dim ll_i As Long
    For ll_i = LBound(asa_invisibleCols) To UBound(asa_invisibleCols)
        ' column A to be zero width
        ao_ExcelSheet.Columns(asa_invisibleCols(ll_i)).columnWidth = 0
    Next
    
    ' row 1 header into
    ao_ExcelSheet.cells(1, ll_visible_col).Value = as_title
    ao_ExcelSheet.cells(1, ll_visible_col).Font.Size = 14
    ao_ExcelSheet.cells(1, ll_visible_col).Font.Bold = True
    
    With ao_ExcelSheet.UsedRange.Rows(2)
        .Font.Italic = True
        .Font.Bold = True
        .Interior.Color = 15395562
    End With
    
    Dim ls_oldCell As String
    ls_oldCell = "z"
    
    Dim ll_Color As Long
    ll_Color = 16777215
    
    For ll_i = 3 To ao_ExcelSheet.UsedRange.Rows.Count
        If ls_oldCell <> Mid(ao_ExcelSheet.UsedRange.cells(ll_i, 1).Text, 1, Len(ls_oldCell)) Then
            ls_oldCell = Split(ao_ExcelSheet.UsedRange.cells(ll_i, 1).Text, "/")(0)
            If ll_Color = 16777215 Then
                ll_Color = 13431551
            Else
                ll_Color = 16777215
            End If
        End If
        
        With ao_ExcelSheet.UsedRange.Rows(ll_i)
            .Interior.Color = ll_Color
        End With
        
    Next
    
'    Dim a As Excel.Worksheet
    With ao_ExcelSheet.UsedRange.Borders(xlEdgeBottom)
        .LineStyle = xlContinuous
        .ColorIndex = 0
        .TintAndShade = 0
        .Weight = xlThick
    End With
    
    
    
  End If
  Exit Sub
ErrorHandler:
    Call ErrorHandler("ExcelAddFormating")

End Sub

Private Function GetColumnIndexes(ByRef ao_grid As ArmGrid, ByVal ab_VisibleOnly As Boolean) As Variant
Dim lv_Columns As Variant
Dim ll_Index As Long
Dim ll_Pos As Long

On Error GoTo ErrorHandler
  
  If ao_grid.Cols > 0 Then
    ReDim lv_Columns(ao_grid.Cols - 1)
    ll_Pos = 0
    For ll_Index = 0 To UBound(lv_Columns)
        If ab_VisibleOnly Then
            If ao_grid.Columns(ll_Index).Width > 0 Then
                lv_Columns(ll_Pos) = ll_Index
                ll_Pos = ll_Pos + 1
            End If
        Else
            lv_Columns(ll_Pos) = ll_Index
            ll_Pos = ll_Pos + 1
        End If
    Next
    If ll_Pos > 0 Then
        ReDim Preserve lv_Columns(ll_Pos - 1)
        GetColumnIndexes = lv_Columns
        Exit Function
    End If
  End If
  GetColumnIndexes = Empty
  Exit Function
ErrorHandler:
    GetColumnIndexes = Empty
    Call ErrorHandler("GetColumnIndexes")
End Function

' *********************************** copy of grid export functionality *******************************************

Private Function SqlStr(ByVal av_Data As Variant, Optional ByVal al_MaxLength As Long = 0, Optional ByVal ab_emptyAsNULL As Boolean = False) As String

    If IsNull(av_Data) Then av_Data = ""
    If ab_emptyAsNULL And av_Data = "" Then
        SqlStr = "NULL"
        Exit Function
    End If
    If al_MaxLength = 0 Then
        SqlStr = "'" & Replace(CStr(av_Data), "'", "''") & "'"
    Else
        SqlStr = "'" & Replace(Left(CStr(av_Data), al_MaxLength), "'", "''") & "'"
    End If
End Function

Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function

Private Sub EmailDCPrint(ByVal as_CARRIER_Code As String, ByVal as_CARRIER_Name As String, ByVal as_Email As String, ByVal as_emlLanguage As String)
Dim lb_EmailOK As Boolean
On Error GoTo ErrHandler
    
    ' check existance of PDF printer
    Dim ll_Idx As Long
    Dim lo_printer As Printer
    Set lo_printer = Nothing
    For ll_Idx = 0 To Printers.Count - 1
        If IsSupportedPDFPrinter(Printers(ll_Idx).DeviceName) Then
            Set lo_printer = Printers(ll_Idx)
            Exit For
        End If
    Next ll_Idx
    
    
    If lo_printer Is Nothing Then
        Call LockScreen(False)
        Call MsgBox(MsgText(5330, ms_Language_Code, "#PDF printer not found. Printing canceled!"))
        Call LockScreen(True)
        Exit Sub
    End If
    
    Do
        Call LockScreen(False)
        as_Email = InputBox(MsgText(5320, ms_Language_Code, "#Do you want to send printing with Mail to"), , as_Email)
        Call LockScreen(True)
        If as_Email = "" Then
            Exit Sub
        End If
        ' check validity of e_mail address entered
        lb_EmailOK = IsEmailValid(as_Email)
        If Not lb_EmailOK Then
            ' M150
            Call LockScreen(False)
            Call MsgBox(MsgText(8150, ms_Language_Code, "#M150 - This email address does not appear to be the correct format (User@domain)."))
            Call LockScreen(True)
            lb_EmailOK = False
        Else
            ' check the length of e-mail address entered
            lb_EmailOK = (Len(as_Email) <= 80)
            If Not lb_EmailOK Then
                ' M730
                Call LockScreen(False)
                Call MsgBox(MsgText(8730, ms_Language_Code, "#M730 - Length of address cannot be more than 80 characters."))
                Call LockScreen(True)
            End If
        End If
        
    Loop Until lb_EmailOK
    
    ' generate attachement
    Dim ls_oldDeviceName  As String
    ls_oldDeviceName = Printer.DeviceName
    
    Set Printer = lo_printer
    If mo_FSO.FileExists(ms_TempPrintFile) Then
        Call mo_FSO.DeleteFile(ms_TempPrintFile, True)
    End If
    
    Call DCLoadPrint(as_CARRIER_Code)
    
    ' check existance of printed file
    Dim ld_StartTime As Date
    ld_StartTime = Now
    Do While Not mo_FSO.FileExists(ms_TempPrintFile)
        DoEvents
        Call Sleep(100)
        ' let's give 2 minutes to give up waiting.
        If DateDiff("n", ld_StartTime, Now) > 2 Then
            Exit Do
        End If
    Loop
    
    If Not mo_FSO.FileExists(ms_TempPrintFile) Then
        Call SetPrinterByName(ls_oldDeviceName)
        
        ReDim ms_MsgInfo(1, 1)
        ms_MsgInfo(0, 0) = "$printer$"
        ms_MsgInfo(0, 1) = lo_printer.DeviceName
        ms_MsgInfo(1, 0) = "$file$"
        ms_MsgInfo(1, 1) = ms_TempPrintFile
        Call MsgBox(MsgText(5340, ms_Language_Code, "#PDF printer ($printer$) is probably not setup to print into $file$! Please change the settings to print into this file.", ms_MsgInfo), vbCritical)
        Exit Sub
    End If

    ' copy the file
    
    Call mo_FSO.CopyFile(ms_TempPrintFile, "Cache\DC_Temp\DC_Print.pdf", True)
    
    ' recover the printer
    Call SetPrinterByName(ls_oldDeviceName)
    
    ' send email
    Dim ll_IdxEmail As Long
    
    ReDim ms_MsgInfo(2, 1)
    ms_MsgInfo(0, 0) = "$TITLE$"
    ms_MsgInfo(0, 1) = grd_main.Title
    ms_MsgInfo(1, 0) = "$CARRIER$"
    ms_MsgInfo(1, 1) = as_CARRIER_Name
    ms_MsgInfo(2, 0) = "$SENDER$"
    ms_MsgInfo(2, 1) = prg.FullName
    
    Dim ls_Subject As String
    ls_Subject = MsgText(Get_A_Config("DC_PRINT_EML_SUBJECT"), as_emlLanguage, "Subject '$TITLE$' of email", ms_MsgInfo)
    
    Dim ls_Body As String
    ls_Body = MsgText(Get_A_Config("DC_PRINT_EML_BODY"), as_emlLanguage, "Body of '$TITLE$' for $CARRIER$ email from $SENDER$", ms_MsgInfo)
    
    
    ll_IdxEmail = mo_MailClient.AddEmail(ls_Subject, ls_Body, False, Now, "")
    Call mo_MailClient.AddEmailAddress(ll_IdxEmail, as_Email, etEmailTo)
    
    Dim ls_currentUserEmail As String
    ls_currentUserEmail = mo_MailClient.GetAddressForUCode(ml_U_Code)
    If ls_currentUserEmail <> "" Then
        Call mo_MailClient.AddEmailAddress(ll_IdxEmail, ls_currentUserEmail, etEmailCopyTo)
    End If
    
    Call mo_MailClient.AddAttachment(ll_IdxEmail, "Cache\DC_Temp", "DC_Print.pdf")
    Call mo_MailClient.SendEmail(ll_IdxEmail)
    
    Call mo_MailClient.ClearData

    
    Call LockScreen(False)
    Call MsgBox(MsgText(5350, ms_Language_Code, "#Email was sent succesfully."), vbInformation)
    Call LockScreen(True)

    Exit Sub
ErrHandler:
    Call ErrorHandler("EmailDCPrint")
End Sub

Private Sub SetPrinterByName(ByVal as_deviceName As String)
On Error GoTo ErrHandler
    Dim ll_Idx As Long
    For ll_Idx = 0 To Printers.Count - 1
        If Printers(ll_Idx).DeviceName = as_deviceName Then
            Set Printer = Printers(ll_Idx)
            Exit For
        End If
    Next ll_Idx
    Exit Sub
ErrHandler:
    Call ErrorHandler("SetPrinterByName")
End Sub

Private Function IsSupportedPDFPrinter(ByVal as_printerName As String) As Boolean
On Error GoTo ErrHandler

    IsSupportedPDFPrinter = False
    
    Dim ll_i As Long
    For ll_i = LBound(msa_PDFDevice) To UBound(msa_PDFDevice)
        If msa_PDFDevice(ll_i) = as_printerName Then
            IsSupportedPDFPrinter = True
            Exit Function
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler("IsSupportedPDFPrinter")
End Function

Private Function IsEmailValid(ByVal as_EmailText As String) As Boolean
On Error GoTo ErrHandler

Dim ls_Email
Dim las_Email() As String
Dim ll_Index As Long

IsEmailValid = True

  If Trim(as_EmailText) <> "" Then
    las_Email = Split(Replace(Trim(as_EmailText), ";", ","), ",")
    For ll_Index = 0 To UBound(las_Email)
      ls_Email = Trim(las_Email(ll_Index))
      If InStr(1, ls_Email, "/") Then
        If CheckLotusEmailFormat(ls_Email) = False Then
            IsEmailValid = False
            Exit Function
        End If
      Else
        If CheckNormalEmailFormat(ls_Email) = False Then
            IsEmailValid = False
            Exit Function
        End If
      End If
    Next
  End If
  Exit Function

ErrHandler:
    Call ErrorHandler("IsEmailValid")
End Function

Private Function CheckLotusEmailFormat(ByVal as_EmailCheck As String) As Boolean
On Error GoTo ErrHandler

Dim lb_CK As Boolean
Dim ll_Index As Long
Dim ll_Index2 As Long
Dim las_EmailParts() As String
Dim ls_EmailPart As String
Const sInvalidChars As String = "@"

    lb_CK = True
    
    las_EmailParts = Split(Trim(as_EmailCheck), "/")
    
    If UBound(las_EmailParts) < 2 Then
        lb_CK = False
        GoTo ExitFunction
    End If
    
    For ll_Index = 0 To UBound(las_EmailParts)
        ls_EmailPart = Trim(las_EmailParts(ll_Index))
        If Trim(ls_EmailPart) = "" Then
            lb_CK = False
            GoTo ExitFunction
        End If
        
        ' Check for invalid characters.
        If Len(as_EmailCheck) > Len(sInvalidChars) Then
            For ll_Index2 = 1 To Len(sInvalidChars)
                If InStr(as_EmailCheck, Mid(sInvalidChars, ll_Index2, 1)) > 0 Then
                    lb_CK = False
                    GoTo ExitFunction
                End If
            Next
        Else
            For ll_Index2 = 1 To Len(as_EmailCheck)
                If InStr(sInvalidChars, Mid(as_EmailCheck, ll_Index2, 1)) > 0 Then
                    lb_CK = False
                    GoTo ExitFunction
                End If
            Next
        End If
    
    Next
    
ExitFunction:
    CheckLotusEmailFormat = lb_CK
    Exit Function

ErrHandler:
    CheckLotusEmailFormat = False
    Call ErrorHandler("CheckLotusEmailFormat")

End Function

Private Function CheckNormalEmailFormat(ByVal as_EmailCheck As String) As Boolean
On Error GoTo ErrHandler

Dim lb_CK As Boolean
Dim ls_DomainType As String
Const sInvalidChars As String = "!#$%^&*()=+{}[]|\;:'/?>,< "
Dim ll_Index As Long

    lb_CK = Not InStr(1, as_EmailCheck, Chr(34)) > 0 'Check to see if there is a double quote
    If Not lb_CK Then GoTo ExitFunction
    
    lb_CK = Not InStr(1, as_EmailCheck, "..") > 0 'Check to see if there are consecutive dots
    If Not lb_CK Then GoTo ExitFunction
    
    ' Check for invalid characters.
    If Len(as_EmailCheck) > Len(sInvalidChars) Then
        For ll_Index = 1 To Len(sInvalidChars)
            If InStr(as_EmailCheck, Mid(sInvalidChars, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    Else
        For ll_Index = 1 To Len(as_EmailCheck)
            If InStr(sInvalidChars, Mid(as_EmailCheck, ll_Index, 1)) > 0 Then
                lb_CK = False
                GoTo ExitFunction
            End If
        Next
    End If
    
    If InStr(1, as_EmailCheck, "@") > 1 Then 'Check for an @ symbol
        lb_CK = Len(Left(as_EmailCheck, InStr(1, as_EmailCheck, "@") - 1)) > 0
        Else
        lb_CK = False
        End If
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "@"))
    lb_CK = Not InStr(1, as_EmailCheck, "@") > 0 'Check to see if there are too many @'s
    If Not lb_CK Then GoTo ExitFunction
    
    If InStr(1, as_EmailCheck, ".") = 0 Then
        lb_CK = False
        GoTo ExitFunction
    End If

    ls_DomainType = right(as_EmailCheck, Len(as_EmailCheck) - InStr(1, as_EmailCheck, "."))
    lb_CK = Len(ls_DomainType) > 0 And InStr(1, as_EmailCheck, ".") < Len(as_EmailCheck)
    If Not lb_CK Then GoTo ExitFunction
    
    as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - Len(ls_DomainType) - 1)
    Do Until InStr(1, as_EmailCheck, ".") <= 1
        If Len(as_EmailCheck) >= InStr(1, as_EmailCheck, ".") Then
            as_EmailCheck = Left(as_EmailCheck, Len(as_EmailCheck) - (InStr(1, as_EmailCheck, ".") - 1))
        Else
            lb_CK = False
            GoTo ExitFunction
        End If
    Loop
    If as_EmailCheck = "." Or Len(as_EmailCheck) = 0 Then lb_CK = False
    
ExitFunction:
    CheckNormalEmailFormat = lb_CK
    Exit Function
    
ErrHandler:
    CheckNormalEmailFormat = False
    Call ErrorHandler("CheckNormalEmailFormat")
End Function

Private Function Get_A_Config(ByVal TheKey As String) As String
On Error GoTo Get_A_Config_er
Dim curs As Long
Dim ls_req As String

    Get_A_Config = ""
    ls_req = "select cfg_value from A_config where cfg_Key ='" & UCase(TheKey) & "'"
    curs = OpenSQLSafe(mo_Db, ls_req, 1)
    
    Get_A_Config = mo_Db.GetFields(curs, 0)
    Call mo_Db.Close(curs)
    curs = 0
    
Exit Function
Get_A_Config_er:
    If curs > 0 Then
        Call mo_Db.Close(curs)
        curs = 0
    End If
    Call ErrorHandler("Get_A_Config()")
End Function

Private Function HaveRight(ByVal as_RightKey As String) As Boolean

    Dim mb_Ok As Boolean
    
    mb_Ok = False
    Dim lc_Data As Long
    lc_Data = mo_Db.OpenSQL("SELECT CFG_Value FROM A_Config WHERE CFG_Key = '" & as_RightKey & "'")
    Dim lv_ArrUpd As Variant
    lv_ArrUpd = Split(mo_Db.GetFields(lc_Data, 0), SEP, , vbTextCompare)
    Call mo_Db.Close(lc_Data)
    Dim ll_Idx As Long, ll_Count As Long
    ll_Count = UBound(lv_ArrUpd)
    For ll_Idx = 0 To ll_Count
        If lv_ArrUpd(ll_Idx) = prg.U_Code Then
            mb_Ok = True
            Exit For
        End If
    Next
    HaveRight = mb_Ok

End Function

